/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.common;

import ibm.nways.jdm.common.CallbackThread;
import ibm.nways.jdm.common.OrderedQueue;
import ibm.nways.jdm.common.Timer;
import ibm.nways.jdm.common.Wakeable;

public class TimerService
extends Thread {
    private static boolean running;
    private static boolean started;
    private static boolean waiting;
    private static OrderedQueue timerQ;
    private static TimerService inst;
    private static Object lock;

    private TimerService() {
    }

    public static void initialize() {
        Object object = lock;
        synchronized (object) {
            if (!started) {
                started = true;
                inst = new TimerService();
                inst.start();
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    public static boolean isReady() {
        boolean bl;
        Object object = lock;
        synchronized (object) {
            bl = started && waiting;
        }
        return bl;
    }

    public static Timer scheduleWakeUp(int n, Wakeable wakeable) {
        return TimerService.scheduleWakeUp(n, wakeable, null);
    }

    public static Timer scheduleWakeUp(int n, Wakeable wakeable, Object object) {
        if (!started) {
            TimerService.initialize();
        }
        if (!running) {
            return null;
        }
        Timer timer = new Timer(n, wakeable, object);
        Object object2 = lock;
        synchronized (object2) {
            boolean bl;
            timerQ.enqueue(timer);
            boolean bl2 = bl = timer == (Timer)timerQ.peek();
            if (bl && waiting) {
                lock.notify();
            }
        }
        return timer;
    }

    public static boolean cancelWakeUp(Timer timer) {
        boolean bl;
        Object object = lock;
        synchronized (object) {
            boolean bl2 = timer == (Timer)timerQ.peek();
            bl = timerQ.dequeue(timer);
            if (bl2 && waiting) {
                lock.notify();
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        TimerService.started = true;
        TimerService.running = true;
        var4_1 = TimerService.lock;
        synchronized (var4_1) {
            TimerService.waiting = true;
            TimerService.lock.notify();
            try {
                TimerService.lock.wait();
            }
            catch (InterruptedException v0) {}
            if (true) ** GOTO lbl48
        }
        do {
            var1_2 = null;
            var2_3 = -1L;
            var4_1 = TimerService.lock;
            synchronized (var4_1) {
                if (!TimerService.timerQ.isEmpty()) {
                    var1_2 = (Timer)TimerService.timerQ.peek();
                    var2_3 = var1_2.getPopTime() - System.currentTimeMillis();
                    if (var2_3 <= 0L) {
                        var1_2 = (Timer)TimerService.timerQ.dequeue();
                    } else {
                        TimerService.waiting = true;
                        try {
                            TimerService.lock.wait(var2_3);
                        }
                        catch (InterruptedException v2) {}
                        TimerService.waiting = false;
                        var1_2 = null;
                    }
                } else {
                    TimerService.waiting = true;
                    try {
                        TimerService.lock.wait();
                    }
                    catch (InterruptedException v3) {}
                    TimerService.waiting = false;
                }
            }
            if (var1_2 == null) continue;
            var4_1 = new CallbackThread(var1_2);
            var4_1.start();
lbl48:
            // 3 sources

        } while (TimerService.running);
    }

    public static void terminate() {
        Object object = lock;
        synchronized (object) {
            if (running) {
                running = false;
                if (waiting) {
                    lock.notify();
                    Thread.yield();
                }
            }
        }
        started = false;
        running = false;
        waiting = false;
    }

    static {
        timerQ = new OrderedQueue();
        inst = null;
        lock = new Object();
    }
}

